/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.parameter.usage;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.Strings;
import com.beust.jcommander.WrappedParameter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.parameter.RequestResponseBodyParameter;
import server.restful.common.parameter.ServletParameterParser;

public class ServletUsageFormatter
extends DefaultUsageFormatter {
    private static final Logger LOG = Logger.getLogger(ServletUsageFormatter.class.getName());
    private JCommander commander;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Exception exception;
    private ResourceBundle bundle;

    public ServletUsageFormatter(JCommander commander, HttpServletRequest request, HttpServletResponse response) {
        super(commander);
        this.commander = commander;
        this.request = request;
        this.response = response;
        this.bundle = this.getBundle();
    }

    public void setException(Exception exception) {
        if (this.exception == null) {
            this.exception = exception;
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void appendMainLine(StringBuilder out, boolean hasOptions, boolean hasCommands, int indentCount, String indent) {
        this.response.setStatus(this.exception != null ? 500 : 200);
        this.response.setContentType(ContentTypeAndFileExtensions.MIME_TYPE_TEXT.toString());
        if (LOG.isLoggable(Level.FINEST)) {
            this.appendCurrentRequestParameters(out, indent);
        }
        if (this.exception != null) {
            this.appendErrorMessage(out);
        }
        out.append(indent).append("Usage: ").append(this.request.getMethod()).append(" ");
        out.append(this.commander.getProgramDisplayName());
        if (this.commander.getMainParameter() != null && this.commander.getMainParameterValue() != null) {
            out.append("[<servlet path>]");
        }
        if (this.commander.getFields().values().stream().filter(pd -> !pd.getParameter().hidden()).count() > 0L) {
            out.append("?[<servlet parameters>]");
        }
        out.append("\n");
        out.append("\n");
        out.append(this.bundle.getString("USAGE_DESCRIPTION"));
        out.append("\n");
        if (this.commander.getMainParameter() != null && this.commander.getMainParameterValue() != null) {
            this.appendServletPath(out, indentCount, indent);
        }
    }

    public void appendAllParametersDetails(StringBuilder out, int indentCount, String indent, List<ParameterDescription> sortedParameters) {
        if (sortedParameters.size() > 0) {
            out.append("\n");
            out.append(indent).append("  Servlet Parameters:\n");
        }
        for (ParameterDescription pd : sortedParameters) {
            Class type;
            WrappedParameter parameter = pd.getParameter();
            String description = pd.getDescription();
            boolean hasDescription = !description.isEmpty();
            out.append(indent).append("  ").append(parameter.required() ? "* " : "  ").append(this.getServletParameterNames(pd.getNames())).append("\n");
            if (hasDescription) {
                this.wrapDescription(out, indentCount, ServletUsageFormatter.s((int)indentCount) + description);
            }
            Object def = pd.getDefault();
            if (pd.isDynamicParameter()) {
                String syntax = "Syntax: " + parameter.names()[0] + "key" + parameter.getAssignment() + "value";
                if (hasDescription) {
                    out.append(ServletUsageFormatter.newLineAndIndent(indentCount));
                } else {
                    out.append(ServletUsageFormatter.s((int)indentCount));
                }
                out.append(syntax);
            }
            if (def != null && !pd.isHelp()) {
                String displayedDef = Strings.isStringEmpty((String)def.toString()) ? "<empty string>" : def.toString();
                String defaultText = "Default: " + (parameter.password() ? "********" : displayedDef);
                if (hasDescription) {
                    out.append(ServletUsageFormatter.newLineAndIndent(indentCount));
                } else {
                    out.append(ServletUsageFormatter.s((int)indentCount));
                }
                out.append(defaultText);
            }
            if ((type = pd.getParameterized().getType()).isEnum()) {
                String valueList = EnumSet.allOf(type).toString();
                String possibleValues = "Possible Values: " + valueList;
                if (!description.contains("Options: " + valueList)) {
                    if (hasDescription) {
                        out.append(ServletUsageFormatter.newLineAndIndent(indentCount));
                    } else {
                        out.append(ServletUsageFormatter.s((int)indentCount));
                    }
                    out.append(possibleValues);
                }
            }
            out.append("\n");
        }
        try {
            this.appendExampleUsage(out, indentCount, indent);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendCurrentRequestParameters(StringBuilder out, String indent) {
        Object[] requestParameters = ServletParameterParser.getRequestParametersAsCommandLine(this.request);
        if (requestParameters.length > 0) {
            out.append(indent).append("  Internal Info: Current servlet parameters converted to command line arguments:");
            out.append("\n");
            out.append(Strings.join((String)" ", (Object[])requestParameters));
            out.append("\n");
            out.append("\n");
        }
    }

    private void appendErrorMessage(StringBuilder out) {
        out.append(this.exception.getClass().getSimpleName());
        out.append(":");
        out.append(ServletUsageFormatter.newLineAndIndent(2));
        out.append(this.exception.getMessage().replaceAll("[mM]ain parameters? are", "servlet path is").replaceAll("[mM]ain class", "servlet").replaceAll("[mM]ain parameters?", "servlet path").replaceAll("[oO]ption", "servlet parameter").replaceAll("--", "").replaceAll("-", ""));
        out.append("\n");
        out.append("--------------------------------------------------------------------------------");
        out.append("\n");
        out.append("\n");
    }

    private void appendServletPath(StringBuilder out, int indentCount, String indent) {
        out.append(ServletUsageFormatter.newLineAndIndent(2)).append("Servlet Path:");
        out.append("\n");
        out.append(indent).append("  ");
        out.append(this.commander.getMainParameterValue().getParameter().required() ? "* " : "  ");
        out.append(this.commander.getMainParameterValue().getDescription());
        out.append("\n");
    }

    private void appendExampleUsage(StringBuilder out, int indentCount, String indent) throws MalformedURLException, URISyntaxException {
        out.append(ServletUsageFormatter.newLineAndIndent(2)).append("Example:");
        out.append("\n");
        this.wrapDescription(out, indentCount, ServletUsageFormatter.s((int)indentCount) + this.createExampleUsage(indent));
        for (String line : this.createRequestResponseBodyExamples()) {
            out.append("\n");
            this.wrapDescription(out, indentCount, ServletUsageFormatter.s((int)indentCount) + line);
        }
        out.append("\n");
        out.append("\n");
    }

    private List<String> createRequestResponseBodyExamples() {
        Object firstParameterObject;
        ArrayList<String> result = new ArrayList<String>();
        if ("POST".equals(this.request.getMethod()) && (firstParameterObject = this.commander.getObjects().get(0)) instanceof RequestResponseBodyParameter) {
            RequestResponseBodyParameter postMethodParameter = (RequestResponseBodyParameter)firstParameterObject;
            Object requestBodyExample = postMethodParameter.getRequestBodyExample();
            Object responseBodyExample = postMethodParameter.getResponseBodyExample();
            if (requestBodyExample != null) {
                result.add("");
                result.add("Request:");
                result.add("--------");
                if (requestBodyExample instanceof RequestResponseBodyParameter.Blob) {
                    result.add("");
                    result.add("Content-Type: " + ContentTypeAndFileExtensions.MIME_TYPE_FORM_URLENCODED.getMimeType());
                    result.add("Body:");
                    result.add("<Blob>");
                } else {
                    for (ContentTypeAndFileExtensions ct : new ContentTypeAndFileExtensions[]{ContentTypeAndFileExtensions.MIME_TYPE_JSON, ContentTypeAndFileExtensions.MIME_TYPE_XML, ContentTypeAndFileExtensions.MIME_TYPE_MULTIPART}) {
                        this.createRequestBodyExample(result, ct, requestBodyExample);
                    }
                }
            }
            if (responseBodyExample != null) {
                result.add("");
                result.add("Response:");
                result.add("---------");
                for (ContentTypeAndFileExtensions ct : new ContentTypeAndFileExtensions[]{ContentTypeAndFileExtensions.MIME_TYPE_JSON, ContentTypeAndFileExtensions.MIME_TYPE_XML}) {
                    this.createResponseBodyExample(result, ct, responseBodyExample);
                }
            }
        }
        return result;
    }

    private void createRequestBodyExample(List<String> result, ContentTypeAndFileExtensions ct, Object requestBodyExample) {
        try {
            switch (ct) {
                case MIME_TYPE_XML: {
                    StringWriter xml = new StringWriter();
                    Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{requestBodyExample.getClass()}).createMarshaller();
                    marshaller.marshal(requestBodyExample, (Writer)xml);
                    result.add("");
                    result.add("Content-Type: " + ct.getMimeType());
                    result.add("Body:");
                    result.add(xml.toString());
                    break;
                }
                case MIME_TYPE_JSON: {
                    result.add("");
                    result.add("Content-Type: " + ct.getMimeType());
                    result.add("Body:");
                    result.add(new ObjectMapper().writeValueAsString(requestBodyExample));
                    break;
                }
                case MIME_TYPE_MULTIPART: {
                    String boundary = UUID.randomUUID().toString();
                    result.add("");
                    result.add("Content-Type: " + "multipart/form-data; boundary=" + boundary);
                    result.add("Body:");
                    result.add("--" + boundary);
                    result.add("Content-disposition: form-data; name=\"file\"; filename=\"filename.ext\"");
                    result.add("Content-Type: " + ContentTypeAndFileExtensions.MIME_TYPE_OCTET_STREAM.getMimeType());
                    result.add("");
                    result.add("54 45 53 54 (example raw binary bytes)");
                    result.add("--" + boundary);
                    break;
                }
            }
        }
        catch (JsonProcessingException | JAXBException throwable) {
            // empty catch block
        }
    }

    private void createResponseBodyExample(List<String> result, ContentTypeAndFileExtensions ct, Object responseBodyExample) {
        try {
            switch (ct) {
                case MIME_TYPE_XML: {
                    StringWriter xml = new StringWriter();
                    JAXBContext.newInstance((Class[])new Class[]{responseBodyExample.getClass()}).createMarshaller().marshal(responseBodyExample, (Writer)xml);
                    result.add("");
                    result.add("Accept: " + ct.getMimeType());
                    result.add("Body:");
                    result.add(xml.toString());
                    break;
                }
                case MIME_TYPE_JSON: {
                    result.add("");
                    result.add("Accept: " + ct.getMimeType());
                    result.add("Body:");
                    result.add(new ObjectMapper().writeValueAsString(responseBodyExample));
                    break;
                }
            }
        }
        catch (JsonProcessingException | JAXBException throwable) {
            // empty catch block
        }
    }

    private String createExampleUsage(String indent) throws MalformedURLException, URISyntaxException {
        StringBuilder result = new StringBuilder();
        result.append(indent).append("HTTP(S)-");
        result.append(this.request.getMethod()).append(" ");
        StringBuilder urlAsString = new StringBuilder();
        urlAsString.append(IServletSystemProperties.JSIDPlay2Server.BASE_URL);
        urlAsString.append(this.commander.getProgramDisplayName());
        if (this.commander.getMainParameter() != null) {
            urlAsString.append(this.bundle.getString("EXAMPLE_REQUEST_PATH"));
        }
        StringBuilder queryParameters = new StringBuilder();
        Iterator it = this.commander.getFields().values().stream().filter(pd -> !pd.getParameter().hidden() && pd.getDefault() != null).sorted(this.commander.getParameterDescriptionComparator()).collect(Collectors.toList()).iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                ParameterDescription def = (ParameterDescription)it.next();
                queryParameters.append(this.getExampleServletParameterName(def.getNames()));
                queryParameters.append("=");
                queryParameters.append(def.getParameter().password() ? "********" : String.valueOf(def.getDefault()));
                if (!it.hasNext()) continue;
                queryParameters.append("&");
            }
        }
        URL url = new URI(urlAsString.toString()).toURL();
        URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), queryParameters.length() > 0 ? queryParameters.toString() : null, url.getRef());
        result.append(uri.toASCIIString());
        return result.toString();
    }

    private String getExampleServletParameterName(String names) {
        return Arrays.asList(names.split(", ")).stream().map(this::getParameterName).max(Comparator.comparingInt(String::length)).orElse("");
    }

    private ResourceBundle getBundle() {
        Object firstParameterObject = this.commander.getObjects().get(0);
        Parameters parameters = firstParameterObject.getClass().getAnnotation(Parameters.class);
        return ResourceBundle.getBundle(parameters.resourceBundle(), Locale.getDefault());
    }

    private String getServletParameterNames(String names) {
        return Arrays.asList(names.split(", ")).stream().map(this::getParameterName).collect(Collectors.joining(", "));
    }

    private String getParameterName(String name) {
        if (name.startsWith("--")) {
            return name.substring("--".length());
        }
        if (name.startsWith("-")) {
            return name.substring("-".length());
        }
        return name;
    }

    private static String newLineAndIndent(int indent) {
        return "\n" + ServletUsageFormatter.s((int)indent);
    }
}

